/* Tanzania Wave 3 data using cleaned version of
wave 3 datafile and including revisions made in light of 
Wave 4 survey information*/

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';



/* check time period used for reporting output data i.e. 
for some firms 1994 data and for others 1995 data */

data check1a; set tz.tz3new; by firm;
options linesize=80;

firm=key;
wave=3;
accts=v1001;
period=v1003;
begin=db;
end=de;
name=v0name;

if begin > 12783 then year=95; else year=94;
keep firm wave accts period begin end year name;


/* WAVE 3 FIRM CHARACTERISTICS */
/* *************************** */

data size3; set tz.tz3new;
options nolabel;

firm=key;
wave=3;

if indu=1 then indlab='food';
if indu=2 then indlab='textile';
if indu=3 then indlab='wood';
if indu=4 then indlab='metal';

if sect=1 then sectlab='formal';
if sect=2 then sectlab='informal';
if sect=3 then sectlab='service';

if indu=1 then food=1; else food=0;
if indu=2 then text=1; else text=0;
if indu=3 then wood=1; else wood=0;
if indu=4 then metal=1; else metal=0;

emppt=v2601pt;
empft=v2601ft;
emp=emppt+empft;

if emp=0 then emp=emp+1;
if firm=84 then emp=14;

emp95=emp;

if emp ge 1 and emp le 5 then size95=1;
if emp ge 6 and emp le 29 then size95=2;
if emp ge 30 and emp le 99 then size95=3;
if emp ge 100 then size95=4;

if size95=. then size95=size;

if size95=1 then sizedum='amicro';
if size95=2 then sizedum='bsmall';
if size95=3 then sizedum='cmedium';
if size95=4 then sizedum='dlarge';

if size95=1 then micro=1; else micro=0;
if size95=2 then small=1; else small=0;
if size95=3 then medium=1; else medium=0;
if size95=4 then large=1; else large=0;

keep firm wave indu indlab sect sectlab loca
emp emppt empft size95 sizedum food text wood metal
micro small medium large emp95;

data size3b; merge size3 check1a; by firm;
size=size95;
if year=94 then size94=size95;
if year=94 then size95=.;


data cd.w3chars; set size3;
proc sort; by firm;



/* WAVE 3 VARIABLES FOR SIMPLE PRODUCTION FUNCTION */
/* *********************************************** */

data check2; set tz.tz3new; by firm;
options linesize=80;

firm=key;
wave=3;

accts=v1001;
period=v1003;

output=v1326;
sales=v1327;
inctrad=v1328;
incserv=v1329;
incoth=v1330;

if output=. then output=sales;
if firm=527 then output=sales;

rawmat=v1438;

rent=v1443a;
elec=v1443b;
water=v1443c;
telef=v1443d;
lfuel=v1443e;
sfuel=v1443f;
trans=v1443g;
secur=v1443h;
maint=v1443i;
advert=v1443j;

if rent=. then rent=0;
if elec=. then elec=0;
if water=. then water=0;
if telef=. then telef=0;
if lfuel=. then lfuel=0;
if sfuel=. then sfuel=0;
if trans=. then trans=0;
if secur=. then secur=0;
if maint=. then maint=0;
if advert=. then advert=0;
if other=. then other=0;

misc=rent+elec+water+telef+lfuel+sfuel+trans+
secur+maint+advert+other;

wages=v1441;
labcost=v1442;
if labcost=. then labcost=wages;

profit=v1545;

/* section to annualise production data */

if period=1 then output=output;
if period=2 then output=output*2;
if period=3 then output=output*12;
if period=4 then output=output*52/2;
if period=5 then output=output*52;
if period=6 then output=output*260;

if period=1 then sales=sales;
if period=2 then sales=sales*2;
if period=3 then sales=sales*12;
if period=4 then sales=sales*52/2;
if period=5 then sales=sales*52;
if period=6 then sales=sales*260;

if period=1 then rawmat=rawmat;
if period=2 then rawmat=rawmat*2;
if period=3 then rawmat=rawmat*12;
if period=4 then rawmat=rawmat*52/2;
if period=5 then rawmat=rawmat*52;
if period=6 then rawmat=rawmat*260;

if period=1 then misc=misc;
if period=2 then misc=misc*2;
if period=3 then misc=misc*12;
if period=4 then misc=misc*52/2;
if period=5 then misc=misc*52;
if period=6 then misc=misc*260;

if period=1 then wages=wages;
if period=2 then wages=wages*2;
if period=3 then wages=wages*12;
if period=4 then wages=wages*52/2;
if period=5 then wages=wages*52;
if period=6 then wages=wages*260;

if period=1 then labcost=labcost;
if period=2 then labcost=labcost*2;
if period=3 then labcost=labcost*12;
if period=4 then labcost=labcost*52/2;
if period=5 then labcost=labcost*52;
if period=6 then labcost=labcost*260;

if period=1 then profit=profit;
if period=2 then profit=profit*2;
if period=3 then profit=profit*12;
if period=4 then profit=profit*52/2;
if period=5 then profit=profit*52;
if period=6 then profit=profit*260;

if period=. then delete;
if period gt 6 then delete;

/* annual sales & raw material purchases figures from tables
to use if observations missing */

sales1=v1217r15;
sales2=v1217r25;
sales3=v1217r35;
sales4=v1217r45;
sales5=v1217r55;

if sales1=. then sales1=0;
if sales2=. then sales2=0;
if sales3=. then sales3=0;
if sales4=. then sales4=0;
if sales5=. then sales5=0;

salecalc=sales1+sales2+sales3+sales4+sales5;

if output=. then output=salecalc;

mat1=v1323r15;
mat2=v1323r25;
mat3=v1323r35;
mat4=v1323r45;
mat5=v1323r55;

if mat1=. then mat1=0;
if mat2=. then mat2=0;
if mat3=. then mat3=0;
if mat4=. then mat4=0;
if mat5=. then mat5=0;

matcalc=mat1+mat2+mat3+mat4+mat5;

if rawmat=. then rawmat=matcalc;

/* revisions to components of VAD made in revision D */
if firm=206 then output=62480000;
if firm=206 then rawmat=44000000;
if firm=205 then rawmat=4800000;
if firm=212 then rawmat=26200000;
if firm=215 then rawmat=12361000;

/* capital stock */
cap=v1655re;
capsale=v1655se;
caplb=v1655rl;
capsallb=v1655sl;

if cap=. then cap=capsale;

/* adjustments to cap stock using information
from other waves or using resale value where this seems
more reliable */

if firm=209 then cap=750000000;
if firm=108 then cap=6000000;
if firm=112 then cap=36000000;
if firm=223 then cap=30000000;
if firm=405 then cap=30000000;
if firm=609 then cap=250000000;
if firm=233 then cap=1700000000;
if firm=4 then cap=500000000;
if firm=36 then cap=250000000;
if firm=620 then cap=3000000;
if firm=72 then cap=102000000;
if firm=85 then cap=1100000000;
if firm=509 then cap=344550000;
if firm=605 then cap=100000000;
if firm=6 then cap=40000000;
if firm=38 then cap=80000000;
if firm=52 then cap=450000000;
if firm=61 then cap=410000;
if firm=62 then cap=100000000;
if firm=93 then cap=50000;
if firm=98 then cap=5550000;
if firm=516 then cap=20000000;
if firm=529 then cap=2500000;
if firm=418 then cap=1650000;
if firm=402 then cap=6500000;
if firm=215 then cap=150000000;
if firm=411 then cap=30000000;
if firm=601 then cap=233000000;
if firm=527 then cap=465000000; /* wave 1 plus 15m investment */

/* adjustments to make consistent with other waves */
if firm=2 then cap=400000;
if firm=16 then cap=2320000;
if firm=26 then cap=1500000;
if firm=51 then cap=1030000;
if firm=68 then cap=2125000000; /* ratio to VAD consistent */
if firm=208 then cap=40544600;
if firm=305 then cap=1000000;
if firm=307 then cap=2000000;
if firm=309 then cap=1000000;
if firm=424 then cap=399300;
if firm=522 then cap=18000000;
if firm=602 then cap=250000000;
if firm=621 then cap=200000;
if firm=57 then cap=1000000000;
if firm=80 then cap=3500000;
if firm=124 then cap=300000;

emppt=v2601pt;
empft=v2601ft;
emp=emppt+empft;

if firm=530 then emp=10;

capemp=cap/emp;

vad=output-misc-rawmat;

prcalc=vad-labcost;


prate=profit/cap;
vademp=vad/emp;
vadcap=vad/cap;
capvad=cap/vad;

export=v1762;
if export=1 then expdum=1; else expdum=0;
pcexp=v1763;
expaf=v1764a;
expnaf=v1764b;

output95=output;
sales95=sales;
rawmat95=rawmat;
misc95=misc;
wages95=wages;
labc95=labcost;
cap95=cap;
capsal95=capsale;
emp95=emp;
vad95=vad;
prof95=profit;
expdum95=expdum;
pcexp95=pcexp;
expaf95=expaf;
expnaf95=expnaf;
capemp95=capemp;
vademp95=vademp;
vadcap95=vadcap;
capvad95=capvad;
prate95=prate;
prcalc95=prcalc;

/* firms excluded from financial calcs due to missing or highly
unreliable production data in wave 3 */
if firm=10 then delete;
if firm=42 then delete;
if firm=74 then delete;
if firm=75 then delete;
if firm=106 then delete;
if firm=117 then delete;
if firm=120 then delete;
if firm=216 then delete;
if firm=232 then delete;
if firm=235 then delete;
if firm=238 then delete;
if firm=311 then delete;
if firm=402 then delete;
if firm=419 then delete;
if firm=422 then delete;
if firm=506 then delete;
if firm=607 then delete;
if firm=520 then delete;
if firm=608 then delete;
if firm=513 then delete;
if firm=225 then delete; /* tourism firm */
if firm=610 then delete; /* exclude in all waves */

keep firm wave accts period output sales inctrad incserv incoth
rawmat misc wages labcost cap capsale caplb capsallb emp emppt empft capemp
vad vademp vadcap capvad profit prate prcalc pcexp export expaf expnaf expdum
output95 sales95 rawmat95 misc95 wages95 labc95 cap95 capsal95 emp95
vad95 prof95 expdum95 pcexp95 expaf95 expnaf95 capemp95 vademp95 vadcap95
capvad95 prate95 prcalc95;



/* programming to separate out firms reporting 1994 data; 
for analysis we combine all firms and deflate 1994/95 data
by different indices in the merge123.sas program */

data check2b; merge check2 (in=a) check1a; by firm; if a;

if year=94 then output94=output;
if year=94 then sales94=sales;
if year=94 then rawmat94=rawmat;
if year=94 then misc94=misc;
if year=94 then wages94=wages;
if year=94 then labc94=labcost;
if year=94 then cap94=cap;
if year=94 then capsal94=capsale;
if year=94 then emp94=emp;
if year=94 then vad94=vad;
if year=94 then prof94=profit;
if year=94 then expdum94=expdum;
if year=94 then pcexp94=pcexport;
if year=94 then expaf94=expaf;
if year=94 then expnaf94=expnaf;
if year=94 then capemp94=capemp;
if year=94 then vademp94=vademp;
if year=94 then vadcap94=vadcap;
if year=94 then capvad94=capvad;
if year=94 then prate94=prate;
if year=94 then prcalc94=prcalc;

if year=94 then output95=.;
if year=94 then sales95=.;
if year=94 then rawmat95=.;
if year=94 then misc95=.;
if year=94 then wages95=.;
if year=94 then labc95=.;
if year=94 then cap95=.;
if year=94 then capsal95=.;
if year=94 then emp95=.;
if year=94 then vad95=.;
if year=94 then prof95=.;
if year=94 then expdum95=.;
if year=94 then pcexp95=.;
if year=94 then expaf95=.;
if year=94 then expnaf95=.;
if year=94 then capemp95=.;
if year=94 then vademp95=.;
if year=94 then vadcap95=.;
if year=94 then capvad95=.;
if year=94 then prate95=.;
if year=94 then prcalc95=.;


/* creates permanent data file with gen firm variables for wave 3 */

data cd.genfirm3; merge check2 (in=a) size3b; by firm; if a;
proc means; run;


/* WAVE 3 PRODUCTION FUNCTIONS  */
/* *************************** */

data check3; merge size3b check2b; by firm;
options nolabel;

if vad<= 0 then delete;
if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

proc means; var firm vad emp cap vadcap capvad; run;
proc reg; model lvad=lcap lemp; run;


/* firms reporting 95 data only */
data check3a; merge size3b check2b; by firm;
options nolabel;

if vad95<= 0 then delete;

if vadcap95 gt 50 then delete;
if capvad95 gt 100 then delete;

lvad95=log(vad95);
lemp95=log(emp95);
lcap95=log(cap95);

proc means; var firm vad95 emp95 cap95 vadcap95 capvad95; run;
proc reg; model lvad95=lcap95 lemp95; run;

/* firms reporting 1994 data only */
data check3b; merge size3b check2b; by firm;
options nolabel;

if vad94<= 0 then delete;

if vadcap94 gt 10 then delete;
if capvad94 gt 100 then delete;

lvad94=log(vad94);
lemp94=log(emp94);
lcap94=log(cap94);

proc means; var firm vad94 emp94 cap94 vadcap94 capvad94; run;
proc reg; model lvad94=lcap94 lemp94;
run;



/* cross tabs for wave 3; full sample and divided by year */

data temp3a; merge check2b (in=a) size3b; by firm; if a;

/*if year=94; */

proc means; var firm emp cap output vad capemp vademp
capvad vadcap; run;

proc sort; by sizedum;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by sizedum; run;

proc sort; by indlab;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by indlab; run;

proc sort; by size95;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by size95; run;

proc sort; by size94;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by size94; run;

